@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.XmlSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A copy activity Xml source.
 * @property additionalColumns Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property formatSettings Xml format settings.
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property storeSettings Xml store settings.
 * @property type Copy source type.
 * Expected value is 'XmlSource'.
 */
public data class XmlSourceArgs(
    public val additionalColumns: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val formatSettings: Output<XmlReadSettingsArgs>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val sourceRetryCount: Output<Any>? = null,
    public val sourceRetryWait: Output<Any>? = null,
    public val storeSettings: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.XmlSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.XmlSourceArgs =
        com.pulumi.azurenative.datafactory.inputs.XmlSourceArgs.builder()
            .additionalColumns(additionalColumns?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .formatSettings(formatSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .sourceRetryCount(sourceRetryCount?.applyValue({ args0 -> args0 }))
            .sourceRetryWait(sourceRetryWait?.applyValue({ args0 -> args0 }))
            .storeSettings(storeSettings?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [XmlSourceArgs].
 */
@PulumiTagMarker
public class XmlSourceArgsBuilder internal constructor() {
    private var additionalColumns: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var formatSettings: Output<XmlReadSettingsArgs>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var sourceRetryCount: Output<Any>? = null

    private var sourceRetryWait: Output<Any>? = null

    private var storeSettings: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("ktxkthxgswwcyyjy")
    public suspend fun additionalColumns(`value`: Output<Any>) {
        this.additionalColumns = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("srhrmwtlolwmkvve")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value Xml format settings.
     */
    @JvmName("aluuxvbapgocaepx")
    public suspend fun formatSettings(`value`: Output<XmlReadSettingsArgs>) {
        this.formatSettings = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("rjueevdxinrenlxq")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("dmuwppfvomdiosom")
    public suspend fun sourceRetryCount(`value`: Output<Any>) {
        this.sourceRetryCount = value
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("eqjsvppkunwwpxud")
    public suspend fun sourceRetryWait(`value`: Output<Any>) {
        this.sourceRetryWait = value
    }

    /**
     * @param value Xml store settings.
     */
    @JvmName("bvltmdqgmicmqlqh")
    public suspend fun storeSettings(`value`: Output<Any>) {
        this.storeSettings = value
    }

    /**
     * @param value Copy source type.
     * Expected value is 'XmlSource'.
     */
    @JvmName("ukpxfjfgcvjqhenj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("govrfqhckwwyqdqk")
    public suspend fun additionalColumns(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalColumns = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("wiofxbruydickjfu")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value Xml format settings.
     */
    @JvmName("gklepgphlqyllurj")
    public suspend fun formatSettings(`value`: XmlReadSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.formatSettings = mapped
    }

    /**
     * @param argument Xml format settings.
     */
    @JvmName("vpovcomcjevylmpn")
    public suspend fun formatSettings(argument: suspend XmlReadSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = XmlReadSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.formatSettings = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("iqvqpwyewvffmpfo")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("hkiryspteqcsutwa")
    public suspend fun sourceRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryCount = mapped
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("tgqxpqjnhsdrirbm")
    public suspend fun sourceRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryWait = mapped
    }

    /**
     * @param value Xml store settings.
     */
    @JvmName("wyamdwrstcmboriv")
    public suspend fun storeSettings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storeSettings = mapped
    }

    /**
     * @param value Copy source type.
     * Expected value is 'XmlSource'.
     */
    @JvmName("gxpvtluqoqaqwgmg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): XmlSourceArgs = XmlSourceArgs(
        additionalColumns = additionalColumns,
        disableMetricsCollection = disableMetricsCollection,
        formatSettings = formatSettings,
        maxConcurrentConnections = maxConcurrentConnections,
        sourceRetryCount = sourceRetryCount,
        sourceRetryWait = sourceRetryWait,
        storeSettings = storeSettings,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
