@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Azure Databricks Delta Lake linked service.
 * @property accessToken Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property clusterId The id of an existing interactive cluster that will be used for all runs of this job. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property credential The credential reference containing authentication information.
 * @property description Linked service description.
 * @property domain <REGION>.azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType string).
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property type Type of linked service.
 * Expected value is 'AzureDatabricksDeltaLake'.
 * @property workspaceResourceId Workspace resource id for databricks REST API. Type: string (or Expression with resultType string).
 */
public data class AzureDatabricksDeltaLakeLinkedServiceResponse(
    public val accessToken: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val annotations: List<Any>? = null,
    public val clusterId: Any? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val credential: CredentialReferenceResponse? = null,
    public val description: String? = null,
    public val domain: Any,
    public val encryptedCredential: String? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val type: String,
    public val workspaceResourceId: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AzureDatabricksDeltaLakeLinkedServiceResponse):
            AzureDatabricksDeltaLakeLinkedServiceResponse =
            AzureDatabricksDeltaLakeLinkedServiceResponse(
                accessToken = javaType.accessToken().map({ args0 ->
                    args0.transform(
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                            })
                        },
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                            })
                        },
                    )
                }).orElse(null),
                annotations = javaType.annotations().map({ args0 -> args0 }),
                clusterId = javaType.clusterId().map({ args0 -> args0 }).orElse(null),
                connectVia = javaType.connectVia().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                credential = javaType.credential().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.CredentialReferenceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                domain = javaType.domain(),
                encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
                parameters = javaType.parameters().map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                        }),
                    )
                }).toMap(),
                type = javaType.type(),
                workspaceResourceId = javaType.workspaceResourceId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
