@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * A copy activity Azure PostgreSQL sink.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
 * @property preCopyScript A query to execute before starting the copy. Type: string (or Expression with resultType string).
 * @property sinkRetryCount Sink retry count. Type: integer (or Expression with resultType integer).
 * @property sinkRetryWait Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy sink type.
 * Expected value is 'AzurePostgreSqlSink'.
 * @property writeBatchSize Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property writeBatchTimeout Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 */
public data class AzurePostgreSqlSinkResponse(
    public val disableMetricsCollection: Any? = null,
    public val maxConcurrentConnections: Any? = null,
    public val preCopyScript: Any? = null,
    public val sinkRetryCount: Any? = null,
    public val sinkRetryWait: Any? = null,
    public val type: String,
    public val writeBatchSize: Any? = null,
    public val writeBatchTimeout: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.AzurePostgreSqlSinkResponse):
            AzurePostgreSqlSinkResponse = AzurePostgreSqlSinkResponse(
            disableMetricsCollection = javaType.disableMetricsCollection().map({ args0 -> args0 }).orElse(null),
            maxConcurrentConnections = javaType.maxConcurrentConnections().map({ args0 -> args0 }).orElse(null),
            preCopyScript = javaType.preCopyScript().map({ args0 -> args0 }).orElse(null),
            sinkRetryCount = javaType.sinkRetryCount().map({ args0 -> args0 }).orElse(null),
            sinkRetryWait = javaType.sinkRetryWait().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            writeBatchSize = javaType.writeBatchSize().map({ args0 -> args0 }).orElse(null),
            writeBatchTimeout = javaType.writeBatchTimeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
