@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Trigger that allows the referenced pipeline to depend on other pipeline runs based on runDimension Name/Value pairs. Upstream pipelines should declare the same runDimension Name and their runs should have the values for those runDimensions. The referenced pipeline run would be triggered if the values for the runDimension match for all upstream pipeline runs.
 * @property annotations List of tags that can be used for describing the trigger.
 * @property dependsOn Upstream Pipelines.
 * @property description Trigger description.
 * @property pipeline Pipeline for which runs are created when all upstream pipelines complete successfully.
 * @property runDimension Run Dimension property that needs to be emitted by upstream pipelines.
 * @property runtimeState Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
 * @property type Trigger type.
 * Expected value is 'ChainingTrigger'.
 */
public data class ChainingTriggerResponse(
    public val annotations: List<Any>? = null,
    public val dependsOn: List<PipelineReferenceResponse>,
    public val description: String? = null,
    public val pipeline: TriggerPipelineReferenceResponse,
    public val runDimension: String,
    public val runtimeState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ChainingTriggerResponse):
            ChainingTriggerResponse = ChainingTriggerResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.PipelineReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            pipeline = javaType.pipeline().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.TriggerPipelineReferenceResponse.Companion.toKotlin(args0)
            }),
            runDimension = javaType.runDimension(),
            runtimeState = javaType.runtimeState(),
            type = javaType.type(),
        )
    }
}
