@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * Staging info for execute data flow activity.
 * @property folderPath Folder path for staging blob. Type: string (or Expression with resultType string)
 * @property linkedService Staging linked service reference.
 */
public data class DataFlowStagingInfoResponse(
    public val folderPath: Any? = null,
    public val linkedService: LinkedServiceReferenceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.DataFlowStagingInfoResponse):
            DataFlowStagingInfoResponse = DataFlowStagingInfoResponse(
            folderPath = javaType.folderPath().map({ args0 -> args0 }).orElse(null),
            linkedService = javaType.linkedService().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
