@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Definition of CMK for the factory.
 * @property identity User assigned identity to use to authenticate to customer's key vault. If not provided Managed Service Identity will be used.
 * @property keyName The name of the key in Azure Key Vault to use as Customer Managed Key.
 * @property keyVersion The version of the key used for CMK. If not provided, latest version will be used.
 * @property vaultBaseUrl The url of the Azure Key Vault used for CMK.
 */
public data class EncryptionConfigurationResponse(
    public val identity: CMKIdentityDefinitionResponse? = null,
    public val keyName: String,
    public val keyVersion: String? = null,
    public val vaultBaseUrl: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.EncryptionConfigurationResponse):
            EncryptionConfigurationResponse = EncryptionConfigurationResponse(
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.CMKIdentityDefinitionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keyName = javaType.keyName(),
            keyVersion = javaType.keyVersion().map({ args0 -> args0 }).orElse(null),
            vaultBaseUrl = javaType.vaultBaseUrl(),
        )
    }
}
