@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Excel dataset.
 * @property annotations List of tags that can be used for describing the Dataset.
 * @property compression The data compression method used for the json dataset.
 * @property description Dataset description.
 * @property firstRowAsHeader When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the first row of data. The default value is false. Type: boolean (or Expression with resultType boolean).
 * @property folder The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
 * @property linkedServiceName Linked service reference.
 * @property location The location of the excel storage.
 * @property nullValue The null value string. Type: string (or Expression with resultType string).
 * @property parameters Parameters for dataset.
 * @property range The partial data of one sheet. Type: string (or Expression with resultType string).
 * @property schema Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
 * @property sheetIndex The sheet index of excel file and default value is 0. Type: integer (or Expression with resultType integer)
 * @property sheetName The sheet name of excel file. Type: string (or Expression with resultType string).
 * @property structure Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
 * @property type Type of dataset.
 * Expected value is 'Excel'.
 */
public data class ExcelDatasetResponse(
    public val annotations: List<Any>? = null,
    public val compression: DatasetCompressionResponse? = null,
    public val description: String? = null,
    public val firstRowAsHeader: Any? = null,
    public val folder: DatasetResponseFolder? = null,
    public val linkedServiceName: LinkedServiceReferenceResponse,
    public val location: Any,
    public val nullValue: Any? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val range: Any? = null,
    public val schema: Any? = null,
    public val sheetIndex: Any? = null,
    public val sheetName: Any? = null,
    public val structure: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ExcelDatasetResponse):
            ExcelDatasetResponse = ExcelDatasetResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            compression = javaType.compression().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DatasetCompressionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            firstRowAsHeader = javaType.firstRowAsHeader().map({ args0 -> args0 }).orElse(null),
            folder = javaType.folder().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DatasetResponseFolder.Companion.toKotlin(args0)
                })
            }).orElse(null),
            linkedServiceName = javaType.linkedServiceName().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location(),
            nullValue = javaType.nullValue().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            range = javaType.range().map({ args0 -> args0 }).orElse(null),
            schema = javaType.schema().map({ args0 -> args0 }).orElse(null),
            sheetIndex = javaType.sheetIndex().map({ args0 -> args0 }).orElse(null),
            sheetName = javaType.sheetName().map({ args0 -> args0 }).orElse(null),
            structure = javaType.structure().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
