@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * Compute properties for data flow activity.
 * @property computeType Compute type of the cluster which will execute data flow job. Possible values include: 'General', 'MemoryOptimized', 'ComputeOptimized'. Type: string (or Expression with resultType string)
 * @property coreCount Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272. Type: integer (or Expression with resultType integer)
 */
public data class ExecuteDataFlowActivityTypePropertiesResponseCompute(
    public val computeType: Any? = null,
    public val coreCount: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ExecuteDataFlowActivityTypePropertiesResponseCompute):
            ExecuteDataFlowActivityTypePropertiesResponseCompute =
            ExecuteDataFlowActivityTypePropertiesResponseCompute(
                computeType = javaType.computeType().map({ args0 -> args0 }).orElse(null),
                coreCount = javaType.coreCount().map({ args0 -> args0 }).orElse(null),
            )
    }
}
