@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Execution policy for an execute pipeline activity.
 * @property secureInput When set to true, Input from activity is considered as secure and will not be logged to monitoring.
 */
public data class ExecutePipelineActivityPolicyResponse(
    public val secureInput: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ExecutePipelineActivityPolicyResponse):
            ExecutePipelineActivityPolicyResponse = ExecutePipelineActivityPolicyResponse(
            secureInput = javaType.secureInput().map({ args0 -> args0 }).orElse(null),
        )
    }
}
