@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Credential resource type.
 * @property etag Etag identifies change in the resource.
 * @property id The resource identifier.
 * @property name The resource name.
 * @property properties Managed Identity Credential properties.
 * @property type The resource type.
 */
public data class GetCredentialOperationResult(
    public val etag: String,
    public val id: String,
    public val name: String,
    public val properties: ManagedIdentityCredentialResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.GetCredentialOperationResult):
            GetCredentialOperationResult = GetCredentialOperationResult(
            etag = javaType.etag(),
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.ManagedIdentityCredentialResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
