@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Data flow resource type.
 * @property etag Etag identifies change in the resource.
 * @property id The resource identifier.
 * @property name The resource name.
 * @property properties Data flow properties.
 * @property type The resource type.
 */
public data class GetDataFlowResult(
    public val etag: String,
    public val id: String,
    public val name: String,
    public val properties: Any,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.GetDataFlowResult):
            GetDataFlowResult = GetDataFlowResult(
            etag = javaType.etag(),
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties(),
            type = javaType.type(),
        )
    }
}
