@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Client secret information for factory's bring your own app repository configuration.
 * @property byoaSecretAkvUrl Bring your own app client secret AKV URL.
 * @property byoaSecretName Bring your own app client secret name in AKV.
 */
public data class GitHubClientSecretResponse(
    public val byoaSecretAkvUrl: String? = null,
    public val byoaSecretName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.GitHubClientSecretResponse):
            GitHubClientSecretResponse = GitHubClientSecretResponse(
            byoaSecretAkvUrl = javaType.byoaSecretAkvUrl().map({ args0 -> args0 }).orElse(null),
            byoaSecretName = javaType.byoaSecretName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
