@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Google BigQuery service linked service.
 * @property additionalProjects A comma-separated list of public BigQuery projects to access. Type: string (or Expression with resultType string).
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR.
 * @property clientId The client id of the google application used to acquire the refresh token. Type: string (or Expression with resultType string).
 * @property clientSecret The client secret of the google application used to acquire the refresh token.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property email The service account email ID that is used for ServiceAuthentication and can only be used on self-hosted IR. Type: string (or Expression with resultType string).
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property keyFilePath The full path to the .p12 key file that is used to authenticate the service account email address and can only be used on self-hosted IR. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property project The default BigQuery project to query against. Type: string (or Expression with resultType string).
 * @property refreshToken The refresh token obtained from Google for authorizing access to BigQuery for UserAuthentication.
 * @property requestGoogleDriveScope Whether to request access to Google Drive. Allowing Google Drive access enables support for federated tables that combine BigQuery data with data from Google Drive. The default value is false. Type: string (or Expression with resultType string).
 * @property trustedCertPath The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'GoogleBigQuery'.
 * @property useSystemTrustStore Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.Type: boolean (or Expression with resultType boolean).
 */
public data class GoogleBigQueryLinkedServiceResponse(
    public val additionalProjects: Any? = null,
    public val annotations: List<Any>? = null,
    public val authenticationType: String,
    public val clientId: Any? = null,
    public val clientSecret: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val description: String? = null,
    public val email: Any? = null,
    public val encryptedCredential: String? = null,
    public val keyFilePath: Any? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val project: Any,
    public val refreshToken: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val requestGoogleDriveScope: Any? = null,
    public val trustedCertPath: Any? = null,
    public val type: String,
    public val useSystemTrustStore: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.GoogleBigQueryLinkedServiceResponse):
            GoogleBigQueryLinkedServiceResponse = GoogleBigQueryLinkedServiceResponse(
            additionalProjects = javaType.additionalProjects().map({ args0 -> args0 }).orElse(null),
            annotations = javaType.annotations().map({ args0 -> args0 }),
            authenticationType = javaType.authenticationType(),
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            clientSecret = javaType.clientSecret().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            keyFilePath = javaType.keyFilePath().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            project = javaType.project(),
            refreshToken = javaType.refreshToken().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            requestGoogleDriveScope = javaType.requestGoogleDriveScope().map({ args0 -> args0 }).orElse(null),
            trustedCertPath = javaType.trustedCertPath().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            useSystemTrustStore = javaType.useSystemTrustStore().map({ args0 -> args0 }).orElse(null),
        )
    }
}
