@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * HDInsight Spark activity.
 * @property arguments The user-specified arguments to HDInsightSparkActivity.
 * @property className The application's Java/Spark main class.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property entryFilePath The relative path to the root folder of the code/package to be executed. Type: string (or Expression with resultType string).
 * @property getDebugInfo Debug info option.
 * @property linkedServiceName Linked service reference.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property policy Activity policy.
 * @property proxyUser The user to impersonate that will execute the job. Type: string (or Expression with resultType string).
 * @property rootPath The root path in 'sparkJobLinkedService' for all the job’s files. Type: string (or Expression with resultType string).
 * @property sparkConfig Spark configuration property.
 * @property sparkJobLinkedService The storage linked service for uploading the entry file and dependencies, and for receiving logs.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'HDInsightSpark'.
 * @property userProperties Activity user properties.
 */
public data class HDInsightSparkActivityResponse(
    public val arguments: List<Any>? = null,
    public val className: String? = null,
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val entryFilePath: Any,
    public val getDebugInfo: String? = null,
    public val linkedServiceName: LinkedServiceReferenceResponse? = null,
    public val name: String,
    public val onInactiveMarkAs: String? = null,
    public val policy: ActivityPolicyResponse? = null,
    public val proxyUser: Any? = null,
    public val rootPath: Any,
    public val sparkConfig: Map<String, Any>? = null,
    public val sparkJobLinkedService: LinkedServiceReferenceResponse? = null,
    public val state: String? = null,
    public val type: String,
    public val userProperties: List<UserPropertyResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.HDInsightSparkActivityResponse):
            HDInsightSparkActivityResponse = HDInsightSparkActivityResponse(
            arguments = javaType.arguments().map({ args0 -> args0 }),
            className = javaType.className().map({ args0 -> args0 }).orElse(null),
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            entryFilePath = javaType.entryFilePath(),
            getDebugInfo = javaType.getDebugInfo().map({ args0 -> args0 }).orElse(null),
            linkedServiceName = javaType.linkedServiceName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            policy = javaType.policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            proxyUser = javaType.proxyUser().map({ args0 -> args0 }).orElse(null),
            rootPath = javaType.rootPath(),
            sparkConfig = javaType.sparkConfig().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            sparkJobLinkedService = javaType.sparkJobLinkedService().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
