@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The compute resource properties for managed integration runtime.
 * @property copyComputeScaleProperties CopyComputeScale properties for managed integration runtime.
 * @property dataFlowProperties Data flow properties for managed integration runtime.
 * @property location The location for managed integration runtime. The supported regions could be found on https://docs.microsoft.com/en-us/azure/data-factory/data-factory-data-movement-activities
 * @property maxParallelExecutionsPerNode Maximum parallel executions count per node for managed integration runtime.
 * @property nodeSize The node size requirement to managed integration runtime.
 * @property numberOfNodes The required number of nodes for managed integration runtime.
 * @property pipelineExternalComputeScaleProperties PipelineExternalComputeScale properties for managed integration runtime.
 * @property vNetProperties VNet properties for managed integration runtime.
 */
public data class IntegrationRuntimeComputePropertiesResponse(
    public val copyComputeScaleProperties: CopyComputeScalePropertiesResponse? = null,
    public val dataFlowProperties: IntegrationRuntimeDataFlowPropertiesResponse? = null,
    public val location: String? = null,
    public val maxParallelExecutionsPerNode: Int? = null,
    public val nodeSize: String? = null,
    public val numberOfNodes: Int? = null,
    public val pipelineExternalComputeScaleProperties: PipelineExternalComputeScalePropertiesResponse? =
        null,
    public val vNetProperties: IntegrationRuntimeVNetPropertiesResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.IntegrationRuntimeComputePropertiesResponse):
            IntegrationRuntimeComputePropertiesResponse = IntegrationRuntimeComputePropertiesResponse(
            copyComputeScaleProperties = javaType.copyComputeScaleProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.CopyComputeScalePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataFlowProperties = javaType.dataFlowProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeDataFlowPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            maxParallelExecutionsPerNode = javaType.maxParallelExecutionsPerNode().map({ args0 ->
                args0
            }).orElse(null),
            nodeSize = javaType.nodeSize().map({ args0 -> args0 }).orElse(null),
            numberOfNodes = javaType.numberOfNodes().map({ args0 -> args0 }).orElse(null),
            pipelineExternalComputeScaleProperties = javaType.pipelineExternalComputeScaleProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.PipelineExternalComputeScalePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vNetProperties = javaType.vNetProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeVNetPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
