@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Integration runtime reference type.
 * @property parameters Arguments for integration runtime.
 * @property referenceName Reference integration runtime name.
 * @property type Type of integration runtime.
 */
public data class IntegrationRuntimeReferenceResponse(
    public val parameters: Map<String, Any>? = null,
    public val referenceName: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.IntegrationRuntimeReferenceResponse):
            IntegrationRuntimeReferenceResponse = IntegrationRuntimeReferenceResponse(
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            referenceName = javaType.referenceName(),
            type = javaType.type(),
        )
    }
}
