@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The linked integration runtime information.
 * @property createTime The creating time of the linked integration runtime.
 * @property dataFactoryLocation The location of the data factory for which the linked integration runtime belong to.
 * @property dataFactoryName The name of the data factory for which the linked integration runtime belong to.
 * @property name The name of the linked integration runtime.
 * @property subscriptionId The subscription ID for which the linked integration runtime belong to.
 */
public data class LinkedIntegrationRuntimeResponse(
    public val createTime: String,
    public val dataFactoryLocation: String,
    public val dataFactoryName: String,
    public val name: String,
    public val subscriptionId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.LinkedIntegrationRuntimeResponse):
            LinkedIntegrationRuntimeResponse = LinkedIntegrationRuntimeResponse(
            createTime = javaType.createTime(),
            dataFactoryLocation = javaType.dataFactoryLocation(),
            dataFactoryName = javaType.dataFactoryName(),
            name = javaType.name(),
            subscriptionId = javaType.subscriptionId(),
        )
    }
}
