@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * Log location settings.
 * @property linkedServiceName Log storage linked service reference.
 * @property path The path to storage for storing detailed logs of activity execution. Type: string (or Expression with resultType string).
 */
public data class LogLocationSettingsResponse(
    public val linkedServiceName: LinkedServiceReferenceResponse,
    public val path: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.LogLocationSettingsResponse):
            LogLocationSettingsResponse = LogLocationSettingsResponse(
            linkedServiceName = javaType.linkedServiceName().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.LinkedServiceReferenceResponse.Companion.toKotlin(args0)
            }),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
        )
    }
}
