@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Source or target connection reference details.
 * @property connectionName Name of the connection
 * @property type Type of connection via linked service or dataset.
 */
public data class MapperConnectionReferenceResponse(
    public val connectionName: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.MapperConnectionReferenceResponse):
            MapperConnectionReferenceResponse = MapperConnectionReferenceResponse(
            connectionName = javaType.connectionName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
