@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * CDC table details.
 * @property dslConnectorProperties List of name/value pairs for connection properties.
 * @property name Name of the table.
 * @property schema List of columns for the source table.
 */
public data class MapperTableResponse(
    public val dslConnectorProperties: List<MapperDslConnectorPropertiesResponse>? = null,
    public val name: String? = null,
    public val schema: List<MapperTableSchemaResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.MapperTableResponse):
            MapperTableResponse = MapperTableResponse(
            dslConnectorProperties = javaType.dslConnectorProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.MapperDslConnectorPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            schema = javaType.schema().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.MapperTableSchemaResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
