@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Mapping data flow.
 * @property annotations List of tags that can be used for describing the data flow.
 * @property description The description of the data flow.
 * @property folder The folder that this data flow is in. If not specified, Data flow will appear at the root level.
 * @property script DataFlow script.
 * @property scriptLines Data flow script lines.
 * @property sinks List of sinks in data flow.
 * @property sources List of sources in data flow.
 * @property transformations List of transformations in data flow.
 * @property type Type of data flow.
 * Expected value is 'MappingDataFlow'.
 */
public data class MappingDataFlowResponse(
    public val annotations: List<Any>? = null,
    public val description: String? = null,
    public val folder: DataFlowResponseFolder? = null,
    public val script: String? = null,
    public val scriptLines: List<String>? = null,
    public val sinks: List<DataFlowSinkResponse>? = null,
    public val sources: List<DataFlowSourceResponse>? = null,
    public val transformations: List<TransformationResponse>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.MappingDataFlowResponse):
            MappingDataFlowResponse = MappingDataFlowResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            folder = javaType.folder().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DataFlowResponseFolder.Companion.toKotlin(args0)
                })
            }).orElse(null),
            script = javaType.script().map({ args0 -> args0 }).orElse(null),
            scriptLines = javaType.scriptLines().map({ args0 -> args0 }),
            sinks = javaType.sinks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DataFlowSinkResponse.Companion.toKotlin(args0)
                })
            }),
            sources = javaType.sources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.DataFlowSourceResponse.Companion.toKotlin(args0)
                })
            }),
            transformations = javaType.transformations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.TransformationResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
