@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Base class for all triggers that support one to many model for trigger to pipeline.
 * @property annotations List of tags that can be used for describing the trigger.
 * @property description Trigger description.
 * @property pipelines Pipelines that need to be started.
 * @property runtimeState Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
 * @property type Trigger type.
 * Expected value is 'MultiplePipelineTrigger'.
 */
public data class MultiplePipelineTriggerResponse(
    public val annotations: List<Any>? = null,
    public val description: String? = null,
    public val pipelines: List<TriggerPipelineReferenceResponse>? = null,
    public val runtimeState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.MultiplePipelineTriggerResponse):
            MultiplePipelineTriggerResponse = MultiplePipelineTriggerResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            pipelines = javaType.pipelines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.TriggerPipelineReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            runtimeState = javaType.runtimeState(),
            type = javaType.type(),
        )
    }
}
