@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The data stored in Optimized Row Columnar (ORC) format.
 * @property deserializer Deserializer. Type: string (or Expression with resultType string).
 * @property serializer Serializer. Type: string (or Expression with resultType string).
 * @property type Type of dataset storage format.
 * Expected value is 'OrcFormat'.
 */
public data class OrcFormatResponse(
    public val deserializer: Any? = null,
    public val serializer: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.OrcFormatResponse):
            OrcFormatResponse = OrcFormatResponse(
            deserializer = javaType.deserializer().map({ args0 -> args0 }).orElse(null),
            serializer = javaType.serializer().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
