@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Map Power Query mashup query to sink dataset(s).
 * @property dataflowSinks List of sinks mapped to Power Query mashup query.
 * @property queryName Name of the query in Power Query mashup document.
 */
public data class PowerQuerySinkMappingResponse(
    public val dataflowSinks: List<PowerQuerySinkResponse>? = null,
    public val queryName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.PowerQuerySinkMappingResponse):
            PowerQuerySinkMappingResponse = PowerQuerySinkMappingResponse(
            dataflowSinks = javaType.dataflowSinks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.PowerQuerySinkResponse.Companion.toKotlin(args0)
                })
            }),
            queryName = javaType.queryName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
