@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * SSIS embedded child package.
 * @property packageContent Content for embedded child package. Type: string (or Expression with resultType string).
 * @property packageLastModifiedDate Last modified date for embedded child package.
 * @property packageName Name for embedded child package.
 * @property packagePath Path for embedded child package. Type: string (or Expression with resultType string).
 */
public data class SSISChildPackageResponse(
    public val packageContent: Any,
    public val packageLastModifiedDate: String? = null,
    public val packageName: String? = null,
    public val packagePath: Any,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SSISChildPackageResponse):
            SSISChildPackageResponse = SSISChildPackageResponse(
            packageContent = javaType.packageContent(),
            packageLastModifiedDate = javaType.packageLastModifiedDate().map({ args0 -> args0 }).orElse(null),
            packageName = javaType.packageName().map({ args0 -> args0 }).orElse(null),
            packagePath = javaType.packagePath(),
        )
    }
}
