@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Linked service for Salesforce Service Cloud V2.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property apiVersion The Salesforce API version used in ADF. The version must be larger than or equal to 47.0 which is required by Salesforce BULK API 2.0. Type: string (or Expression with resultType string).
 * @property authenticationType The authentication type to be used to connect to the Salesforce. Currently, we only support OAuth2ClientCredentials, it is also the default value
 * @property clientId The client Id for OAuth 2.0 Client Credentials Flow authentication of the Salesforce instance. Type: string (or Expression with resultType string).
 * @property clientSecret The client secret for OAuth 2.0 Client Credentials Flow authentication of the Salesforce instance.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property environmentUrl The URL of Salesforce Service Cloud instance. For example, 'https://[domain].my.salesforce.com'. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property type Type of linked service.
 * Expected value is 'SalesforceServiceCloudV2'.
 */
public data class SalesforceServiceCloudV2LinkedServiceResponse(
    public val annotations: List<Any>? = null,
    public val apiVersion: Any? = null,
    public val authenticationType: Any? = null,
    public val clientId: Any? = null,
    public val clientSecret: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val environmentUrl: Any? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SalesforceServiceCloudV2LinkedServiceResponse):
            SalesforceServiceCloudV2LinkedServiceResponse =
            SalesforceServiceCloudV2LinkedServiceResponse(
                annotations = javaType.annotations().map({ args0 -> args0 }),
                apiVersion = javaType.apiVersion().map({ args0 -> args0 }).orElse(null),
                authenticationType = javaType.authenticationType().map({ args0 -> args0 }).orElse(null),
                clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
                clientSecret = javaType.clientSecret().map({ args0 ->
                    args0.transform(
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                            })
                        },
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                            })
                        },
                    )
                }).orElse(null),
                connectVia = javaType.connectVia().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
                environmentUrl = javaType.environmentUrl().map({ args0 -> args0 }).orElse(null),
                parameters = javaType.parameters().map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                        }),
                    )
                }).toMap(),
                type = javaType.type(),
            )
    }
}
