@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * A copy activity source for SAP ODP source.
 * @property additionalColumns Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property extractionMode The extraction mode. Allowed value include: Full, Delta and Recovery. The default value is Full. Type: string (or Expression with resultType string).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property projection Specifies the columns to be selected from source data. Type: array of objects(projection) (or Expression with resultType array of objects).
 * @property queryTimeout Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property selection Specifies the selection conditions from source data. Type: array of objects(selection) (or Expression with resultType array of objects).
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property subscriberProcess The subscriber process to manage the delta process. Type: string (or Expression with resultType string).
 * @property type Copy source type.
 * Expected value is 'SapOdpSource'.
 */
public data class SapOdpSourceResponse(
    public val additionalColumns: Any? = null,
    public val disableMetricsCollection: Any? = null,
    public val extractionMode: Any? = null,
    public val maxConcurrentConnections: Any? = null,
    public val projection: Any? = null,
    public val queryTimeout: Any? = null,
    public val selection: Any? = null,
    public val sourceRetryCount: Any? = null,
    public val sourceRetryWait: Any? = null,
    public val subscriberProcess: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SapOdpSourceResponse):
            SapOdpSourceResponse = SapOdpSourceResponse(
            additionalColumns = javaType.additionalColumns().map({ args0 -> args0 }).orElse(null),
            disableMetricsCollection = javaType.disableMetricsCollection().map({ args0 -> args0 }).orElse(null),
            extractionMode = javaType.extractionMode().map({ args0 -> args0 }).orElse(null),
            maxConcurrentConnections = javaType.maxConcurrentConnections().map({ args0 -> args0 }).orElse(null),
            projection = javaType.projection().map({ args0 -> args0 }).orElse(null),
            queryTimeout = javaType.queryTimeout().map({ args0 -> args0 }).orElse(null),
            selection = javaType.selection().map({ args0 -> args0 }).orElse(null),
            sourceRetryCount = javaType.sourceRetryCount().map({ args0 -> args0 }).orElse(null),
            sourceRetryWait = javaType.sourceRetryWait().map({ args0 -> args0 }).orElse(null),
            subscriberProcess = javaType.subscriberProcess().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
