@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Custom script action to run on HDI ondemand cluster once it's up.
 * @property name The user provided name of the script action.
 * @property parameters The parameters for the script action.
 * @property roles The node types on which the script action should be executed.
 * @property uri The URI for the script action.
 */
public data class ScriptActionResponse(
    public val name: String,
    public val parameters: String? = null,
    public val roles: Any,
    public val uri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ScriptActionResponse):
            ScriptActionResponse = ScriptActionResponse(
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 -> args0 }).orElse(null),
            roles = javaType.roles(),
            uri = javaType.uri(),
        )
    }
}
