@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Set value for a Variable.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property policy Activity policy.
 * @property setSystemVariable If set to true, it sets the pipeline run return value.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'SetVariable'.
 * @property userProperties Activity user properties.
 * @property value Value to be set. Could be a static value or Expression.
 * @property variableName Name of the variable whose value needs to be set.
 */
public data class SetVariableActivityResponse(
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val name: String,
    public val onInactiveMarkAs: String? = null,
    public val policy: SecureInputOutputPolicyResponse? = null,
    public val setSystemVariable: Boolean? = null,
    public val state: String? = null,
    public val type: String,
    public val userProperties: List<UserPropertyResponse>? = null,
    public val `value`: Any? = null,
    public val variableName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SetVariableActivityResponse):
            SetVariableActivityResponse = SetVariableActivityResponse(
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            policy = javaType.policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.SecureInputOutputPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            setSystemVariable = javaType.setSystemVariable().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
            variableName = javaType.variableName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
