@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A linked service for an SSH File Transfer Protocol (SFTP) server.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The authentication type to be used to connect to the FTP server.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property host The SFTP server host name. Type: string (or Expression with resultType string).
 * @property hostKeyFingerprint The host key finger-print of the SFTP server. When SkipHostKeyValidation is false, HostKeyFingerprint should be specified. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property passPhrase The password to decrypt the SSH private key if the SSH private key is encrypted.
 * @property password Password to logon the SFTP server for Basic authentication.
 * @property port The TCP port number that the SFTP server uses to listen for client connections. Default value is 22. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property privateKeyContent Base64 encoded SSH private key content for SshPublicKey authentication. For on-premises copy with SshPublicKey authentication, either PrivateKeyPath or PrivateKeyContent should be specified. SSH private key should be OpenSSH format.
 * @property privateKeyPath The SSH private key file path for SshPublicKey authentication. Only valid for on-premises copy. For on-premises copy with SshPublicKey authentication, either PrivateKeyPath or PrivateKeyContent should be specified. SSH private key should be OpenSSH format. Type: string (or Expression with resultType string).
 * @property skipHostKeyValidation If true, skip the SSH host key validation. Default value is false. Type: boolean (or Expression with resultType boolean).
 * @property type Type of linked service.
 * Expected value is 'Sftp'.
 * @property userName The username used to log on to the SFTP server. Type: string (or Expression with resultType string).
 */
public data class SftpServerLinkedServiceResponse(
    public val annotations: List<Any>? = null,
    public val authenticationType: String? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val host: Any,
    public val hostKeyFingerprint: Any? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val passPhrase: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val password: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val port: Any? = null,
    public val privateKeyContent: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? =
        null,
    public val privateKeyPath: Any? = null,
    public val skipHostKeyValidation: Any? = null,
    public val type: String,
    public val userName: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SftpServerLinkedServiceResponse):
            SftpServerLinkedServiceResponse = SftpServerLinkedServiceResponse(
            annotations = javaType.annotations().map({ args0 -> args0 }),
            authenticationType = javaType.authenticationType().map({ args0 -> args0 }).orElse(null),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            host = javaType.host(),
            hostKeyFingerprint = javaType.hostKeyFingerprint().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            passPhrase = javaType.passPhrase().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            password = javaType.password().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            privateKeyContent = javaType.privateKeyContent().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            privateKeyPath = javaType.privateKeyPath().map({ args0 -> args0 }).orElse(null),
            skipHostKeyValidation = javaType.skipHostKeyValidation().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
