@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * SQL Server linked service.
 * @property alwaysEncryptedSettings Sql always encrypted properties.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property connectionString The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property password The on-premises Windows authentication password.
 * @property type Type of linked service.
 * Expected value is 'SqlServer'.
 * @property userName The on-premises Windows authentication user name. Type: string (or Expression with resultType string).
 */
public data class SqlServerLinkedServiceResponse(
    public val alwaysEncryptedSettings: SqlAlwaysEncryptedPropertiesResponse? = null,
    public val annotations: List<Any>? = null,
    public val connectVia: IntegrationRuntimeReferenceResponse? = null,
    public val connectionString: Any,
    public val description: String? = null,
    public val encryptedCredential: String? = null,
    public val parameters: Map<String, ParameterSpecificationResponse>? = null,
    public val password: Either<AzureKeyVaultSecretReferenceResponse, SecureStringResponse>? = null,
    public val type: String,
    public val userName: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.SqlServerLinkedServiceResponse):
            SqlServerLinkedServiceResponse = SqlServerLinkedServiceResponse(
            alwaysEncryptedSettings = javaType.alwaysEncryptedSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.SqlAlwaysEncryptedPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            annotations = javaType.annotations().map({ args0 -> args0 }),
            connectVia = javaType.connectVia().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.IntegrationRuntimeReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            connectionString = javaType.connectionString(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encryptedCredential = javaType.encryptedCredential().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.datafactory.kotlin.outputs.ParameterSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            password = javaType.password().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.AzureKeyVaultSecretReferenceResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.datafactory.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            type = javaType.type(),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
