@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * This activity verifies that an external resource exists.
 * @property childItems Can be used if dataset points to a folder. If set to true, the folder must have at least one file. If set to false, the folder must be empty. Type: boolean (or Expression with resultType boolean).
 * @property dataset Validation activity dataset reference.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property minimumSize Can be used if dataset points to a file. The file must be greater than or equal in size to the value specified. Type: integer (or Expression with resultType integer).
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property sleep A delay in seconds between validation attempts. If no value is specified, 10 seconds will be used as the default. Type: integer (or Expression with resultType integer).
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property timeout Specifies the timeout for the activity to run. If there is no value specified, it takes the value of TimeSpan.FromDays(7) which is 1 week as default. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Type of activity.
 * Expected value is 'Validation'.
 * @property userProperties Activity user properties.
 */
public data class ValidationActivityResponse(
    public val childItems: Any? = null,
    public val dataset: DatasetReferenceResponse,
    public val dependsOn: List<ActivityDependencyResponse>? = null,
    public val description: String? = null,
    public val minimumSize: Any? = null,
    public val name: String,
    public val onInactiveMarkAs: String? = null,
    public val sleep: Any? = null,
    public val state: String? = null,
    public val timeout: Any? = null,
    public val type: String,
    public val userProperties: List<UserPropertyResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.ValidationActivityResponse):
            ValidationActivityResponse = ValidationActivityResponse(
            childItems = javaType.childItems().map({ args0 -> args0 }).orElse(null),
            dataset = javaType.dataset().let({ args0 ->
                com.pulumi.azurenative.datafactory.kotlin.outputs.DatasetReferenceResponse.Companion.toKotlin(args0)
            }),
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.ActivityDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            minimumSize = javaType.minimumSize().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            onInactiveMarkAs = javaType.onInactiveMarkAs().map({ args0 -> args0 }).orElse(null),
            sleep = javaType.sleep().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userProperties = javaType.userProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.datafactory.kotlin.outputs.UserPropertyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
