@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Xml read settings.
 * @property compressionProperties Compression settings.
 * @property detectDataType Indicates whether type detection is enabled when reading the xml files. Type: boolean (or Expression with resultType boolean).
 * @property namespacePrefixes Namespace uri to prefix mappings to override the prefixes in column names when namespace is enabled, if no prefix is defined for a namespace uri, the prefix of xml element/attribute name in the xml data file will be used. Example: "{"http://www.example.com/xml":"prefix"}" Type: object (or Expression with resultType object).
 * @property namespaces Indicates whether namespace is enabled when reading the xml files. Type: boolean (or Expression with resultType boolean).
 * @property type The read setting type.
 * Expected value is 'XmlReadSettings'.
 * @property validationMode Indicates what validation method is used when reading the xml files. Allowed values: 'none', 'xsd', or 'dtd'. Type: string (or Expression with resultType string).
 */
public data class XmlReadSettingsResponse(
    public val compressionProperties: Any? = null,
    public val detectDataType: Any? = null,
    public val namespacePrefixes: Any? = null,
    public val namespaces: Any? = null,
    public val type: String,
    public val validationMode: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.outputs.XmlReadSettingsResponse):
            XmlReadSettingsResponse = XmlReadSettingsResponse(
            compressionProperties = javaType.compressionProperties().map({ args0 -> args0 }).orElse(null),
            detectDataType = javaType.detectDataType().map({ args0 -> args0 }).orElse(null),
            namespacePrefixes = javaType.namespacePrefixes().map({ args0 -> args0 }).orElse(null),
            namespaces = javaType.namespaces().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            validationMode = javaType.validationMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
