@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakeanalytics.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The current state of allowing or disallowing IPs originating within Azure through the firewall. If the firewall is disabled, this is not enforced.
 */
public enum class FirewallAllowAzureIpsState(
    public val javaValue: com.pulumi.azurenative.datalakeanalytics.enums.FirewallAllowAzureIpsState,
) : ConvertibleToJava<com.pulumi.azurenative.datalakeanalytics.enums.FirewallAllowAzureIpsState> {
    Enabled(com.pulumi.azurenative.datalakeanalytics.enums.FirewallAllowAzureIpsState.Enabled),
    Disabled(com.pulumi.azurenative.datalakeanalytics.enums.FirewallAllowAzureIpsState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.datalakeanalytics.enums.FirewallAllowAzureIpsState =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datalakeanalytics.enums.FirewallAllowAzureIpsState):
            FirewallAllowAzureIpsState =
            FirewallAllowAzureIpsState.values().first { it.javaValue == javaType }
    }
}
