@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakeanalytics.kotlin.inputs

import com.pulumi.azurenative.datalakeanalytics.inputs.AddStorageAccountWithAccountParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The parameters used to add a new Azure Storage account while creating a new Data Lake Analytics account.
 * @property accessKey The access key associated with this Azure Storage account that will be used to connect to it.
 * @property name The unique name of the Azure Storage account to add.
 * @property suffix The optional suffix for the storage account.
 */
public data class AddStorageAccountWithAccountParametersArgs(
    public val accessKey: Output<String>,
    public val name: Output<String>,
    public val suffix: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datalakeanalytics.inputs.AddStorageAccountWithAccountParametersArgs> {
    override fun toJava():
        com.pulumi.azurenative.datalakeanalytics.inputs.AddStorageAccountWithAccountParametersArgs =
        com.pulumi.azurenative.datalakeanalytics.inputs.AddStorageAccountWithAccountParametersArgs.builder()
            .accessKey(accessKey.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .suffix(suffix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AddStorageAccountWithAccountParametersArgs].
 */
@PulumiTagMarker
public class AddStorageAccountWithAccountParametersArgsBuilder internal constructor() {
    private var accessKey: Output<String>? = null

    private var name: Output<String>? = null

    private var suffix: Output<String>? = null

    /**
     * @param value The access key associated with this Azure Storage account that will be used to connect to it.
     */
    @JvmName("xsbdpstfmdkldnfa")
    public suspend fun accessKey(`value`: Output<String>) {
        this.accessKey = value
    }

    /**
     * @param value The unique name of the Azure Storage account to add.
     */
    @JvmName("kntmnsgeeopwtdem")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The optional suffix for the storage account.
     */
    @JvmName("ramttnvejlfnxohq")
    public suspend fun suffix(`value`: Output<String>) {
        this.suffix = value
    }

    /**
     * @param value The access key associated with this Azure Storage account that will be used to connect to it.
     */
    @JvmName("ehhudmnkpewpwnvf")
    public suspend fun accessKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessKey = mapped
    }

    /**
     * @param value The unique name of the Azure Storage account to add.
     */
    @JvmName("gtlmfwsmpxunjkoq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The optional suffix for the storage account.
     */
    @JvmName("gxyhqwcfgpluhefr")
    public suspend fun suffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suffix = mapped
    }

    internal fun build(): AddStorageAccountWithAccountParametersArgs =
        AddStorageAccountWithAccountParametersArgs(
            accessKey = accessKey ?: throw PulumiNullFieldException("accessKey"),
            name = name ?: throw PulumiNullFieldException("name"),
            suffix = suffix,
        )
}
