@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakeanalytics.kotlin.inputs

import com.pulumi.azurenative.datalakeanalytics.inputs.CreateFirewallRuleWithAccountParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The parameters used to create a new firewall rule while creating a new Data Lake Analytics account.
 * @property endIpAddress The end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
 * @property name The unique name of the firewall rule to create.
 * @property startIpAddress The start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
 */
public data class CreateFirewallRuleWithAccountParametersArgs(
    public val endIpAddress: Output<String>,
    public val name: Output<String>,
    public val startIpAddress: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datalakeanalytics.inputs.CreateFirewallRuleWithAccountParametersArgs> {
    override fun toJava():
        com.pulumi.azurenative.datalakeanalytics.inputs.CreateFirewallRuleWithAccountParametersArgs =
        com.pulumi.azurenative.datalakeanalytics.inputs.CreateFirewallRuleWithAccountParametersArgs.builder()
            .endIpAddress(endIpAddress.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .startIpAddress(startIpAddress.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CreateFirewallRuleWithAccountParametersArgs].
 */
@PulumiTagMarker
public class CreateFirewallRuleWithAccountParametersArgsBuilder internal constructor() {
    private var endIpAddress: Output<String>? = null

    private var name: Output<String>? = null

    private var startIpAddress: Output<String>? = null

    /**
     * @param value The end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
     */
    @JvmName("ektxafrxcnexabuu")
    public suspend fun endIpAddress(`value`: Output<String>) {
        this.endIpAddress = value
    }

    /**
     * @param value The unique name of the firewall rule to create.
     */
    @JvmName("laafdhdqrwkorhur")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
     */
    @JvmName("clfypaapoxxswvsa")
    public suspend fun startIpAddress(`value`: Output<String>) {
        this.startIpAddress = value
    }

    /**
     * @param value The end IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
     */
    @JvmName("jigrogabhcfcnaxq")
    public suspend fun endIpAddress(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endIpAddress = mapped
    }

    /**
     * @param value The unique name of the firewall rule to create.
     */
    @JvmName("xltslrsbekkmawtx")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The start IP address for the firewall rule. This can be either ipv4 or ipv6. Start and End should be in the same protocol.
     */
    @JvmName("alwocyjfchlyvrqf")
    public suspend fun startIpAddress(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startIpAddress = mapped
    }

    internal fun build(): CreateFirewallRuleWithAccountParametersArgs =
        CreateFirewallRuleWithAccountParametersArgs(
            endIpAddress = endIpAddress ?: throw PulumiNullFieldException("endIpAddress"),
            name = name ?: throw PulumiNullFieldException("name"),
            startIpAddress = startIpAddress ?: throw PulumiNullFieldException("startIpAddress"),
        )
}
