@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakeanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property databaseName The databaseName for the Hive MetaStore
 * @property id The resource identifier.
 * @property name The resource name.
 * @property nestedResourceProvisioningState The current state of the NestedResource
 * @property password The password for the Hive MetaStore
 * @property runtimeVersion The runtimeVersion for the Hive MetaStore
 * @property serverUri The serverUri for the Hive MetaStore
 * @property type The resource type.
 * @property userName The userName for the Hive MetaStore
 */
public data class HiveMetastoreResponse(
    public val databaseName: String,
    public val id: String,
    public val name: String,
    public val nestedResourceProvisioningState: String,
    public val password: String,
    public val runtimeVersion: String,
    public val serverUri: String,
    public val type: String,
    public val userName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datalakeanalytics.outputs.HiveMetastoreResponse):
            HiveMetastoreResponse = HiveMetastoreResponse(
            databaseName = javaType.databaseName(),
            id = javaType.id(),
            name = javaType.name(),
            nestedResourceProvisioningState = javaType.nestedResourceProvisioningState(),
            password = javaType.password(),
            runtimeVersion = javaType.runtimeVersion(),
            serverUri = javaType.serverUri(),
            type = javaType.type(),
            userName = javaType.userName(),
        )
    }
}
