@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of encryption configuration being used. Currently the only supported types are 'UserManaged' and 'ServiceManaged'.
 */
public enum class EncryptionConfigType(
    public val javaValue: com.pulumi.azurenative.datalakestore.enums.EncryptionConfigType,
) : ConvertibleToJava<com.pulumi.azurenative.datalakestore.enums.EncryptionConfigType> {
    UserManaged(com.pulumi.azurenative.datalakestore.enums.EncryptionConfigType.UserManaged),
    ServiceManaged(com.pulumi.azurenative.datalakestore.enums.EncryptionConfigType.ServiceManaged),
    ;

    override fun toJava(): com.pulumi.azurenative.datalakestore.enums.EncryptionConfigType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datalakestore.enums.EncryptionConfigType):
            EncryptionConfigType = EncryptionConfigType.values().first { it.javaValue == javaType }
    }
}
