@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datalakestore.kotlin.inputs

import com.pulumi.azurenative.datalakestore.inputs.CreateVirtualNetworkRuleWithAccountParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The parameters used to create a new virtual network rule while creating a new Data Lake Store account.
 * @property name The unique name of the virtual network rule to create.
 * @property subnetId The resource identifier for the subnet.
 */
public data class CreateVirtualNetworkRuleWithAccountParametersArgs(
    public val name: Output<String>,
    public val subnetId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datalakestore.inputs.CreateVirtualNetworkRuleWithAccountParametersArgs> {
    override fun toJava():
        com.pulumi.azurenative.datalakestore.inputs.CreateVirtualNetworkRuleWithAccountParametersArgs =
        com.pulumi.azurenative.datalakestore.inputs.CreateVirtualNetworkRuleWithAccountParametersArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .subnetId(subnetId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CreateVirtualNetworkRuleWithAccountParametersArgs].
 */
@PulumiTagMarker
public class CreateVirtualNetworkRuleWithAccountParametersArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value The unique name of the virtual network rule to create.
     */
    @JvmName("dddgpjbjfgjevfhs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource identifier for the subnet.
     */
    @JvmName("temwvhhjhbtupdan")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The unique name of the virtual network rule to create.
     */
    @JvmName("merojjpbwurghfij")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource identifier for the subnet.
     */
    @JvmName("qkkoenuyntpjbpjq")
    public suspend fun subnetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): CreateVirtualNetworkRuleWithAccountParametersArgs =
        CreateVirtualNetworkRuleWithAccountParametersArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            subnetId = subnetId ?: throw PulumiNullFieldException("subnetId"),
        )
}
