@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin

import com.pulumi.azurenative.datamigration.kotlin.outputs.ProjectFilePropertiesResponse
import com.pulumi.azurenative.datamigration.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.datamigration.kotlin.outputs.ProjectFilePropertiesResponse.Companion.toKotlin as projectFilePropertiesResponseToKotlin
import com.pulumi.azurenative.datamigration.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [File].
 */
@PulumiTagMarker
public class FileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FileArgs = FileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FileArgsBuilder.() -> Unit) {
        val builder = FileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): File {
        val builtJavaResource = com.pulumi.azurenative.datamigration.File(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return File(builtJavaResource)
    }
}

/**
 * A file resource
 * Azure REST API version: 2021-06-30. Prior API version in Azure Native 1.x: 2018-07-15-preview.
 * Other available API versions: 2022-03-30-preview, 2023-07-15-preview.
 * ## Example Usage
 * ### Files_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var file = new AzureNative.DataMigration.File("file", new()
 *     {
 *         FileName = "x114d023d8",
 *         GroupName = "DmsSdkRg",
 *         ProjectName = "DmsSdkProject",
 *         Properties = new AzureNative.DataMigration.Inputs.ProjectFilePropertiesArgs
 *         {
 *             FilePath = "DmsSdkFilePath/DmsSdkFile.sql",
 *         },
 *         ServiceName = "DmsSdkService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datamigration.NewFile(ctx, "file", &datamigration.FileArgs{
 * 			FileName:    pulumi.String("x114d023d8"),
 * 			GroupName:   pulumi.String("DmsSdkRg"),
 * 			ProjectName: pulumi.String("DmsSdkProject"),
 * 			Properties: &datamigration.ProjectFilePropertiesArgs{
 * 				FilePath: pulumi.String("DmsSdkFilePath/DmsSdkFile.sql"),
 * 			},
 * 			ServiceName: pulumi.String("DmsSdkService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.File;
 * import com.pulumi.azurenative.datamigration.FileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var file = new File("file", FileArgs.builder()
 *             .fileName("x114d023d8")
 *             .groupName("DmsSdkRg")
 *             .projectName("DmsSdkProject")
 *             .properties(Map.of("filePath", "DmsSdkFilePath/DmsSdkFile.sql"))
 *             .serviceName("DmsSdkService")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datamigration:File x114d023d8 /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/projects/{projectName}/files/{fileName}
 * ```
 */
public class File internal constructor(
    override val javaResource: com.pulumi.azurenative.datamigration.File,
) : KotlinCustomResource(javaResource, FileMapper) {
    /**
     * HTTP strong entity tag value. This is ignored if submitted.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Custom file properties
     */
    public val properties: Output<ProjectFilePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                projectFilePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FileMapper : ResourceMapper<File> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datamigration.File::class == javaResource::class

    override fun map(javaResource: Resource): File = File(
        javaResource as
            com.pulumi.azurenative.datamigration.File,
    )
}

/**
 * @see [File].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [File].
 */
public suspend fun `file`(name: String, block: suspend FileResourceBuilder.() -> Unit): File {
    val builder = FileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [File].
 * @param name The _unique_ name of the resulting resource.
 */
public fun `file`(name: String): File {
    val builder = FileResourceBuilder()
    builder.name(name)
    return builder.build()
}
