@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin

import com.pulumi.azurenative.datamigration.MigrationServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Migration Service.
 * Azure REST API version: 2023-07-15-preview.
 * ## Example Usage
 * ### Create or Update Migration Service with maximum parameters.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var migrationService = new AzureNative.DataMigration.MigrationService("migrationService", new()
 *     {
 *         Location = "northeurope",
 *         MigrationServiceName = "testagent",
 *         ResourceGroupName = "testrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datamigration.NewMigrationService(ctx, "migrationService", &datamigration.MigrationServiceArgs{
 * 			Location:             pulumi.String("northeurope"),
 * 			MigrationServiceName: pulumi.String("testagent"),
 * 			ResourceGroupName:    pulumi.String("testrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.MigrationService;
 * import com.pulumi.azurenative.datamigration.MigrationServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var migrationService = new MigrationService("migrationService", MigrationServiceArgs.builder()
 *             .location("northeurope")
 *             .migrationServiceName("testagent")
 *             .resourceGroupName("testrg")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Migration Service with minimum parameters.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var migrationService = new AzureNative.DataMigration.MigrationService("migrationService", new()
 *     {
 *         Location = "northeurope",
 *         MigrationServiceName = "testagent",
 *         ResourceGroupName = "testrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datamigration.NewMigrationService(ctx, "migrationService", &datamigration.MigrationServiceArgs{
 * 			Location:             pulumi.String("northeurope"),
 * 			MigrationServiceName: pulumi.String("testagent"),
 * 			ResourceGroupName:    pulumi.String("testrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.MigrationService;
 * import com.pulumi.azurenative.datamigration.MigrationServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var migrationService = new MigrationService("migrationService", MigrationServiceArgs.builder()
 *             .location("northeurope")
 *             .migrationServiceName("testagent")
 *             .resourceGroupName("testrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datamigration:MigrationService testagent /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/migrationServices/{migrationServiceName}
 * ```
 * @property location The geo-location where the resource lives
 * @property migrationServiceName Name of the Migration Service.
 * @property resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property tags Resource tags.
 */
public data class MigrationServiceArgs(
    public val location: Output<String>? = null,
    public val migrationServiceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.MigrationServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.MigrationServiceArgs =
        com.pulumi.azurenative.datamigration.MigrationServiceArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .migrationServiceName(migrationServiceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MigrationServiceArgs].
 */
@PulumiTagMarker
public class MigrationServiceArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var migrationServiceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vycqwxfrwqbsrbyn")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the Migration Service.
     */
    @JvmName("jvlchebccevbtsja")
    public suspend fun migrationServiceName(`value`: Output<String>) {
        this.migrationServiceName = value
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ryqvqprddkmdpmvu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hfwdhwkxpjpagifn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("pmgmfhjrtyjsmbmo")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the Migration Service.
     */
    @JvmName("esnuptnfotxvxdqh")
    public suspend fun migrationServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationServiceName = mapped
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("wkvgtuytvveauspu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hblnqbdoprgobdrr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("brkrepmbyrklniqi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MigrationServiceArgs = MigrationServiceArgs(
        location = location,
        migrationServiceName = migrationServiceName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
