@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin

import com.pulumi.azurenative.datamigration.ServiceTaskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A task resource
 * Azure REST API version: 2021-06-30.
 * Other available API versions: 2022-03-30-preview, 2023-07-15-preview.
 * ## Example Usage
 * ### Tasks_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceTask = new AzureNative.DataMigration.ServiceTask("serviceTask", new()
 *     {
 *         GroupName = "DmsSdkRg",
 *         Properties =
 *         {
 *             { "input", new AzureNative.DataMigration.Inputs.MongoDbConnectionInfoArgs
 *             {
 *                 ServerVersion = "NA",
 *             } },
 *             { "taskType", "Service.Check.OCI" },
 *         },
 *         ServiceName = "DmsSdkService",
 *         TaskName = "DmsSdkTask",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datamigration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := datamigration.NewServiceTask(ctx, "serviceTask", &datamigration.ServiceTaskArgs{
 * GroupName: pulumi.String("DmsSdkRg"),
 * Properties: interface{}{
 * Input: &datamigration.MongoDbConnectionInfoArgs{
 * ServerVersion: "NA",
 * },
 * TaskType: pulumi.String("Service.Check.OCI"),
 * },
 * ServiceName: pulumi.String("DmsSdkService"),
 * TaskName: pulumi.String("DmsSdkTask"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datamigration.ServiceTask;
 * import com.pulumi.azurenative.datamigration.ServiceTaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceTask = new ServiceTask("serviceTask", ServiceTaskArgs.builder()
 *             .groupName("DmsSdkRg")
 *             .properties(Map.ofEntries(
 *                 Map.entry("input", Map.of("serverVersion", "NA")),
 *                 Map.entry("taskType", "Service.Check.OCI")
 *             ))
 *             .serviceName("DmsSdkService")
 *             .taskName("DmsSdkTask")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datamigration:ServiceTask DmsSdkTask /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.DataMigration/services/{serviceName}/serviceTasks/{taskName}
 * ```
 * @property groupName Name of the resource group
 * @property properties Custom task properties
 * @property serviceName Name of the service
 * @property taskName Name of the Task
 */
public data class ServiceTaskArgs(
    public val groupName: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val serviceName: Output<String>? = null,
    public val taskName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.ServiceTaskArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.ServiceTaskArgs =
        com.pulumi.azurenative.datamigration.ServiceTaskArgs.builder()
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .taskName(taskName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceTaskArgs].
 */
@PulumiTagMarker
public class ServiceTaskArgsBuilder internal constructor() {
    private var groupName: Output<String>? = null

    private var properties: Output<Any>? = null

    private var serviceName: Output<String>? = null

    private var taskName: Output<String>? = null

    /**
     * @param value Name of the resource group
     */
    @JvmName("suvwpwuxfdhhjrdj")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value Custom task properties
     */
    @JvmName("ovcnwvsnpxacpneq")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value Name of the service
     */
    @JvmName("ltlbkkkhppjpfoxi")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Name of the Task
     */
    @JvmName("onlomaswooguutwf")
    public suspend fun taskName(`value`: Output<String>) {
        this.taskName = value
    }

    /**
     * @param value Name of the resource group
     */
    @JvmName("mqxkvjqydcfeujfw")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value Custom task properties
     */
    @JvmName("wcgrtsgxxlptddey")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Name of the service
     */
    @JvmName("diyqwcjfxdcryqty")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Name of the Task
     */
    @JvmName("vmjvloobuhvalsen")
    public suspend fun taskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskName = mapped
    }

    internal fun build(): ServiceTaskArgs = ServiceTaskArgs(
        groupName = groupName,
        properties = properties,
        serviceName = serviceName,
        taskName = taskName,
    )
}
