@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ConnectToTargetSqlMISyncTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Input for the task that validates connection to Azure SQL Database Managed Instance online scenario.
 * @property azureApp Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
 * @property targetConnectionInfo Connection information for Azure SQL Database Managed Instance
 */
public data class ConnectToTargetSqlMISyncTaskInputArgs(
    public val azureApp: Output<AzureActiveDirectoryAppArgs>,
    public val targetConnectionInfo: Output<MiSqlConnectionInfoArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ConnectToTargetSqlMISyncTaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.ConnectToTargetSqlMISyncTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.ConnectToTargetSqlMISyncTaskInputArgs.builder()
            .azureApp(azureApp.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetConnectionInfo(
                targetConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectToTargetSqlMISyncTaskInputArgs].
 */
@PulumiTagMarker
public class ConnectToTargetSqlMISyncTaskInputArgsBuilder internal constructor() {
    private var azureApp: Output<AzureActiveDirectoryAppArgs>? = null

    private var targetConnectionInfo: Output<MiSqlConnectionInfoArgs>? = null

    /**
     * @param value Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
     */
    @JvmName("udjrfiigsuipescs")
    public suspend fun azureApp(`value`: Output<AzureActiveDirectoryAppArgs>) {
        this.azureApp = value
    }

    /**
     * @param value Connection information for Azure SQL Database Managed Instance
     */
    @JvmName("sfmibfrtxsoxplco")
    public suspend fun targetConnectionInfo(`value`: Output<MiSqlConnectionInfoArgs>) {
        this.targetConnectionInfo = value
    }

    /**
     * @param value Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
     */
    @JvmName("wcdirvkeupcqkjpw")
    public suspend fun azureApp(`value`: AzureActiveDirectoryAppArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureApp = mapped
    }

    /**
     * @param argument Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
     */
    @JvmName("bwxyeocfcuslglwy")
    public suspend fun azureApp(argument: suspend AzureActiveDirectoryAppArgsBuilder.() -> Unit) {
        val toBeMapped = AzureActiveDirectoryAppArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureApp = mapped
    }

    /**
     * @param value Connection information for Azure SQL Database Managed Instance
     */
    @JvmName("lntxfggpvhmycuyk")
    public suspend fun targetConnectionInfo(`value`: MiSqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for Azure SQL Database Managed Instance
     */
    @JvmName("dwtdssubhueinloy")
    public suspend
    fun targetConnectionInfo(argument: suspend MiSqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = MiSqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetConnectionInfo = mapped
    }

    internal fun build(): ConnectToTargetSqlMISyncTaskInputArgs =
        ConnectToTargetSqlMISyncTaskInputArgs(
            azureApp = azureApp ?: throw PulumiNullFieldException("azureApp"),
            targetConnectionInfo = targetConnectionInfo ?: throw
                PulumiNullFieldException("targetConnectionInfo"),
        )
}
