@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.ConnectToTargetSqlMITaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Input for the task that validates connection to Azure SQL Database Managed Instance.
 * @property collectAgentJobs Flag for whether to collect agent jobs from target SQL MI server.
 * @property collectLogins Flag for whether to collect logins from target SQL MI server.
 * @property targetConnectionInfo Connection information for target SQL Server
 * @property validateSsisCatalogOnly Flag for whether to validate SSIS catalog is reachable on the target SQL MI server.
 */
public data class ConnectToTargetSqlMITaskInputArgs(
    public val collectAgentJobs: Output<Boolean>? = null,
    public val collectLogins: Output<Boolean>? = null,
    public val targetConnectionInfo: Output<SqlConnectionInfoArgs>,
    public val validateSsisCatalogOnly: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.ConnectToTargetSqlMITaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.ConnectToTargetSqlMITaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.ConnectToTargetSqlMITaskInputArgs.builder()
            .collectAgentJobs(collectAgentJobs?.applyValue({ args0 -> args0 }))
            .collectLogins(collectLogins?.applyValue({ args0 -> args0 }))
            .targetConnectionInfo(
                targetConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .validateSsisCatalogOnly(validateSsisCatalogOnly?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectToTargetSqlMITaskInputArgs].
 */
@PulumiTagMarker
public class ConnectToTargetSqlMITaskInputArgsBuilder internal constructor() {
    private var collectAgentJobs: Output<Boolean>? = null

    private var collectLogins: Output<Boolean>? = null

    private var targetConnectionInfo: Output<SqlConnectionInfoArgs>? = null

    private var validateSsisCatalogOnly: Output<Boolean>? = null

    /**
     * @param value Flag for whether to collect agent jobs from target SQL MI server.
     */
    @JvmName("ablyqfvhqjebchto")
    public suspend fun collectAgentJobs(`value`: Output<Boolean>) {
        this.collectAgentJobs = value
    }

    /**
     * @param value Flag for whether to collect logins from target SQL MI server.
     */
    @JvmName("tvxalwmdepganixm")
    public suspend fun collectLogins(`value`: Output<Boolean>) {
        this.collectLogins = value
    }

    /**
     * @param value Connection information for target SQL Server
     */
    @JvmName("wiunwpdqnrwyxcco")
    public suspend fun targetConnectionInfo(`value`: Output<SqlConnectionInfoArgs>) {
        this.targetConnectionInfo = value
    }

    /**
     * @param value Flag for whether to validate SSIS catalog is reachable on the target SQL MI server.
     */
    @JvmName("ijbfupjmgvstpcmi")
    public suspend fun validateSsisCatalogOnly(`value`: Output<Boolean>) {
        this.validateSsisCatalogOnly = value
    }

    /**
     * @param value Flag for whether to collect agent jobs from target SQL MI server.
     */
    @JvmName("cphmuulbsbotxffy")
    public suspend fun collectAgentJobs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectAgentJobs = mapped
    }

    /**
     * @param value Flag for whether to collect logins from target SQL MI server.
     */
    @JvmName("uaeeoxokkkeytcex")
    public suspend fun collectLogins(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectLogins = mapped
    }

    /**
     * @param value Connection information for target SQL Server
     */
    @JvmName("mtowmqrxefcdlrfx")
    public suspend fun targetConnectionInfo(`value`: SqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for target SQL Server
     */
    @JvmName("nsjvmxfoqyjdsebw")
    public suspend
    fun targetConnectionInfo(argument: suspend SqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetConnectionInfo = mapped
    }

    /**
     * @param value Flag for whether to validate SSIS catalog is reachable on the target SQL MI server.
     */
    @JvmName("nwpoxtywuxculirb")
    public suspend fun validateSsisCatalogOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validateSsisCatalogOnly = mapped
    }

    internal fun build(): ConnectToTargetSqlMITaskInputArgs = ConnectToTargetSqlMITaskInputArgs(
        collectAgentJobs = collectAgentJobs,
        collectLogins = collectLogins,
        targetConnectionInfo = targetConnectionInfo ?: throw
            PulumiNullFieldException("targetConnectionInfo"),
        validateSsisCatalogOnly = validateSsisCatalogOnly,
    )
}
