@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.DatabaseMigrationPropertiesSqlDbArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Database Migration Resource properties for SQL database.
 * @property kind
 * Expected value is 'SqlDb'.
 * @property migrationOperationId ID tracking current migration operation.
 * @property migrationService Resource Id of the Migration Service.
 * @property provisioningError Error message for migration provisioning failure, if any.
 * @property scope Resource Id of the target resource (SQL VM or SQL Managed Instance).
 * @property sourceDatabaseName Name of the source database.
 * @property sourceSqlConnection Source SQL Server connection details.
 * @property tableList List of tables to copy.
 * @property targetDatabaseCollation Database collation to be used for the target database.
 * @property targetSqlConnection Target SQL DB connection details.
 */
public data class DatabaseMigrationPropertiesSqlDbArgs(
    public val kind: Output<String>,
    public val migrationOperationId: Output<String>? = null,
    public val migrationService: Output<String>? = null,
    public val provisioningError: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val sourceDatabaseName: Output<String>? = null,
    public val sourceSqlConnection: Output<SqlConnectionInformationArgs>? = null,
    public val tableList: Output<List<String>>? = null,
    public val targetDatabaseCollation: Output<String>? = null,
    public val targetSqlConnection: Output<SqlConnectionInformationArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.DatabaseMigrationPropertiesSqlDbArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.DatabaseMigrationPropertiesSqlDbArgs =
        com.pulumi.azurenative.datamigration.inputs.DatabaseMigrationPropertiesSqlDbArgs.builder()
            .kind(kind.applyValue({ args0 -> args0 }))
            .migrationOperationId(migrationOperationId?.applyValue({ args0 -> args0 }))
            .migrationService(migrationService?.applyValue({ args0 -> args0 }))
            .provisioningError(provisioningError?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .sourceDatabaseName(sourceDatabaseName?.applyValue({ args0 -> args0 }))
            .sourceSqlConnection(
                sourceSqlConnection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tableList(tableList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .targetDatabaseCollation(targetDatabaseCollation?.applyValue({ args0 -> args0 }))
            .targetSqlConnection(
                targetSqlConnection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DatabaseMigrationPropertiesSqlDbArgs].
 */
@PulumiTagMarker
public class DatabaseMigrationPropertiesSqlDbArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var migrationOperationId: Output<String>? = null

    private var migrationService: Output<String>? = null

    private var provisioningError: Output<String>? = null

    private var scope: Output<String>? = null

    private var sourceDatabaseName: Output<String>? = null

    private var sourceSqlConnection: Output<SqlConnectionInformationArgs>? = null

    private var tableList: Output<List<String>>? = null

    private var targetDatabaseCollation: Output<String>? = null

    private var targetSqlConnection: Output<SqlConnectionInformationArgs>? = null

    /**
     * @param value
     * Expected value is 'SqlDb'.
     */
    @JvmName("rsorttowyysndgoa")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value ID tracking current migration operation.
     */
    @JvmName("epgqcvgnqyksxrac")
    public suspend fun migrationOperationId(`value`: Output<String>) {
        this.migrationOperationId = value
    }

    /**
     * @param value Resource Id of the Migration Service.
     */
    @JvmName("qexndafqbddjhqil")
    public suspend fun migrationService(`value`: Output<String>) {
        this.migrationService = value
    }

    /**
     * @param value Error message for migration provisioning failure, if any.
     */
    @JvmName("rkvrwjqjewjsceop")
    public suspend fun provisioningError(`value`: Output<String>) {
        this.provisioningError = value
    }

    /**
     * @param value Resource Id of the target resource (SQL VM or SQL Managed Instance).
     */
    @JvmName("jwmubolflfugnnlc")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Name of the source database.
     */
    @JvmName("uigjrxgahyxtnjnr")
    public suspend fun sourceDatabaseName(`value`: Output<String>) {
        this.sourceDatabaseName = value
    }

    /**
     * @param value Source SQL Server connection details.
     */
    @JvmName("mwujemdhqrsnfmcd")
    public suspend fun sourceSqlConnection(`value`: Output<SqlConnectionInformationArgs>) {
        this.sourceSqlConnection = value
    }

    /**
     * @param value List of tables to copy.
     */
    @JvmName("jikberogbjhqbofd")
    public suspend fun tableList(`value`: Output<List<String>>) {
        this.tableList = value
    }

    @JvmName("aiqcrhfebwyoulka")
    public suspend fun tableList(vararg values: Output<String>) {
        this.tableList = Output.all(values.asList())
    }

    /**
     * @param values List of tables to copy.
     */
    @JvmName("jeitohstursklgnf")
    public suspend fun tableList(values: List<Output<String>>) {
        this.tableList = Output.all(values)
    }

    /**
     * @param value Database collation to be used for the target database.
     */
    @JvmName("tgfjquoalthbamio")
    public suspend fun targetDatabaseCollation(`value`: Output<String>) {
        this.targetDatabaseCollation = value
    }

    /**
     * @param value Target SQL DB connection details.
     */
    @JvmName("pbtpyexyqutnspqt")
    public suspend fun targetSqlConnection(`value`: Output<SqlConnectionInformationArgs>) {
        this.targetSqlConnection = value
    }

    /**
     * @param value
     * Expected value is 'SqlDb'.
     */
    @JvmName("acwmnbfbxxjrcdmw")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value ID tracking current migration operation.
     */
    @JvmName("ctfktmcmrurcjetp")
    public suspend fun migrationOperationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationOperationId = mapped
    }

    /**
     * @param value Resource Id of the Migration Service.
     */
    @JvmName("ybbapascmgvxjjgv")
    public suspend fun migrationService(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationService = mapped
    }

    /**
     * @param value Error message for migration provisioning failure, if any.
     */
    @JvmName("nlpevjefqsvvowhg")
    public suspend fun provisioningError(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningError = mapped
    }

    /**
     * @param value Resource Id of the target resource (SQL VM or SQL Managed Instance).
     */
    @JvmName("afhmjecolyouveey")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value Name of the source database.
     */
    @JvmName("neulgnmjsaodhyqt")
    public suspend fun sourceDatabaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDatabaseName = mapped
    }

    /**
     * @param value Source SQL Server connection details.
     */
    @JvmName("xnpnfjsofmolirle")
    public suspend fun sourceSqlConnection(`value`: SqlConnectionInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceSqlConnection = mapped
    }

    /**
     * @param argument Source SQL Server connection details.
     */
    @JvmName("tjaplgsulhpltqdl")
    public suspend
    fun sourceSqlConnection(argument: suspend SqlConnectionInformationArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceSqlConnection = mapped
    }

    /**
     * @param value List of tables to copy.
     */
    @JvmName("ybpyiexbdamsmfvj")
    public suspend fun tableList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableList = mapped
    }

    /**
     * @param values List of tables to copy.
     */
    @JvmName("edpdnrmexpvqtknk")
    public suspend fun tableList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableList = mapped
    }

    /**
     * @param value Database collation to be used for the target database.
     */
    @JvmName("qyutpocjxmtkmptl")
    public suspend fun targetDatabaseCollation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDatabaseCollation = mapped
    }

    /**
     * @param value Target SQL DB connection details.
     */
    @JvmName("qcfvwuyojqthaiiq")
    public suspend fun targetSqlConnection(`value`: SqlConnectionInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetSqlConnection = mapped
    }

    /**
     * @param argument Target SQL DB connection details.
     */
    @JvmName("astaavxhtrhvcrri")
    public suspend
    fun targetSqlConnection(argument: suspend SqlConnectionInformationArgsBuilder.() -> Unit) {
        val toBeMapped = SqlConnectionInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetSqlConnection = mapped
    }

    internal fun build(): DatabaseMigrationPropertiesSqlDbArgs = DatabaseMigrationPropertiesSqlDbArgs(
        kind = kind ?: throw PulumiNullFieldException("kind"),
        migrationOperationId = migrationOperationId,
        migrationService = migrationService,
        provisioningError = provisioningError,
        scope = scope,
        sourceDatabaseName = sourceDatabaseName,
        sourceSqlConnection = sourceSqlConnection,
        tableList = tableList,
        targetDatabaseCollation = targetDatabaseCollation,
        targetSqlConnection = targetSqlConnection,
    )
}
