@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.GetFilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fileName Name of the File
 * @property groupName Name of the resource group
 * @property projectName Name of the project
 * @property serviceName Name of the service
 */
public data class GetFilePlainArgs(
    public val fileName: String,
    public val groupName: String,
    public val projectName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.GetFilePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.GetFilePlainArgs =
        com.pulumi.azurenative.datamigration.inputs.GetFilePlainArgs.builder()
            .fileName(fileName.let({ args0 -> args0 }))
            .groupName(groupName.let({ args0 -> args0 }))
            .projectName(projectName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFilePlainArgs].
 */
@PulumiTagMarker
public class GetFilePlainArgsBuilder internal constructor() {
    private var fileName: String? = null

    private var groupName: String? = null

    private var projectName: String? = null

    private var serviceName: String? = null

    /**
     * @param value Name of the File
     */
    @JvmName("ynwauxnqsjepfjqm")
    public suspend fun fileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fileName = mapped
    }

    /**
     * @param value Name of the resource group
     */
    @JvmName("dksyntktlqchjfjl")
    public suspend fun groupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupName = mapped
    }

    /**
     * @param value Name of the project
     */
    @JvmName("hfhxpucuuiigahpy")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value Name of the service
     */
    @JvmName("tkfjstfpwsuykmue")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetFilePlainArgs = GetFilePlainArgs(
        fileName = fileName ?: throw PulumiNullFieldException("fileName"),
        groupName = groupName ?: throw PulumiNullFieldException("groupName"),
        projectName = projectName ?: throw PulumiNullFieldException("projectName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
