@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MiSqlConnectionInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties required to create a connection to Azure SQL database Managed instance
 * @property managedInstanceResourceId Resource id for Azure SQL database Managed instance
 * @property password Password credential.
 * @property type Type of connection info
 * Expected value is 'MiSqlConnectionInfo'.
 * @property userName User name
 */
public data class MiSqlConnectionInfoArgs(
    public val managedInstanceResourceId: Output<String>,
    public val password: Output<String>? = null,
    public val type: Output<String>,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MiSqlConnectionInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.datamigration.inputs.MiSqlConnectionInfoArgs =
        com.pulumi.azurenative.datamigration.inputs.MiSqlConnectionInfoArgs.builder()
            .managedInstanceResourceId(managedInstanceResourceId.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MiSqlConnectionInfoArgs].
 */
@PulumiTagMarker
public class MiSqlConnectionInfoArgsBuilder internal constructor() {
    private var managedInstanceResourceId: Output<String>? = null

    private var password: Output<String>? = null

    private var type: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Resource id for Azure SQL database Managed instance
     */
    @JvmName("yijyahtxsobmpspm")
    public suspend fun managedInstanceResourceId(`value`: Output<String>) {
        this.managedInstanceResourceId = value
    }

    /**
     * @param value Password credential.
     */
    @JvmName("kcwnudunykammfvh")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Type of connection info
     * Expected value is 'MiSqlConnectionInfo'.
     */
    @JvmName("ucpxogesquaigkhj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value User name
     */
    @JvmName("rbmhdvlesmaiuliv")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Resource id for Azure SQL database Managed instance
     */
    @JvmName("rcmgdhuxipmdjeds")
    public suspend fun managedInstanceResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedInstanceResourceId = mapped
    }

    /**
     * @param value Password credential.
     */
    @JvmName("tfllvcxvkuafxveq")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Type of connection info
     * Expected value is 'MiSqlConnectionInfo'.
     */
    @JvmName("rhfjwmkbpppkalje")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value User name
     */
    @JvmName("gifqmrecjmfnbxxs")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): MiSqlConnectionInfoArgs = MiSqlConnectionInfoArgs(
        managedInstanceResourceId = managedInstanceResourceId ?: throw
            PulumiNullFieldException("managedInstanceResourceId"),
        password = password,
        type = type ?: throw PulumiNullFieldException("type"),
        userName = userName,
    )
}
