@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MigrateMySqlAzureDbForMySqlOfflineTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Input for the task that migrates MySQL databases to Azure Database for MySQL for offline migrations
 * @property makeSourceServerReadOnly Setting to set the source server read only
 * @property optionalAgentSettings Optional parameters for fine tuning the data transfer rate during migration
 * @property selectedDatabases Databases to migrate
 * @property sourceConnectionInfo Connection information for source MySQL
 * @property startedOn Parameter to specify when the migration started
 * @property targetConnectionInfo Connection information for target Azure Database for MySQL
 */
public data class MigrateMySqlAzureDbForMySqlOfflineTaskInputArgs(
    public val makeSourceServerReadOnly: Output<Boolean>? = null,
    public val optionalAgentSettings: Output<Map<String, String>>? = null,
    public val selectedDatabases: Output<List<MigrateMySqlAzureDbForMySqlOfflineDatabaseInputArgs>>,
    public val sourceConnectionInfo: Output<MySqlConnectionInfoArgs>,
    public val startedOn: Output<String>? = null,
    public val targetConnectionInfo: Output<MySqlConnectionInfoArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MigrateMySqlAzureDbForMySqlOfflineTaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.MigrateMySqlAzureDbForMySqlOfflineTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.MigrateMySqlAzureDbForMySqlOfflineTaskInputArgs.builder()
            .makeSourceServerReadOnly(makeSourceServerReadOnly?.applyValue({ args0 -> args0 }))
            .optionalAgentSettings(
                optionalAgentSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .selectedDatabases(
                selectedDatabases.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceConnectionInfo(
                sourceConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .startedOn(startedOn?.applyValue({ args0 -> args0 }))
            .targetConnectionInfo(
                targetConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [MigrateMySqlAzureDbForMySqlOfflineTaskInputArgs].
 */
@PulumiTagMarker
public class MigrateMySqlAzureDbForMySqlOfflineTaskInputArgsBuilder internal constructor() {
    private var makeSourceServerReadOnly: Output<Boolean>? = null

    private var optionalAgentSettings: Output<Map<String, String>>? = null

    private var selectedDatabases: Output<List<MigrateMySqlAzureDbForMySqlOfflineDatabaseInputArgs>>? =
        null

    private var sourceConnectionInfo: Output<MySqlConnectionInfoArgs>? = null

    private var startedOn: Output<String>? = null

    private var targetConnectionInfo: Output<MySqlConnectionInfoArgs>? = null

    /**
     * @param value Setting to set the source server read only
     */
    @JvmName("smxkrbuwhxgxggpc")
    public suspend fun makeSourceServerReadOnly(`value`: Output<Boolean>) {
        this.makeSourceServerReadOnly = value
    }

    /**
     * @param value Optional parameters for fine tuning the data transfer rate during migration
     */
    @JvmName("sjplmmarscpnjcnr")
    public suspend fun optionalAgentSettings(`value`: Output<Map<String, String>>) {
        this.optionalAgentSettings = value
    }

    /**
     * @param value Databases to migrate
     */
    @JvmName("fpnddsicvmbupqjq")
    public suspend
    fun selectedDatabases(`value`: Output<List<MigrateMySqlAzureDbForMySqlOfflineDatabaseInputArgs>>) {
        this.selectedDatabases = value
    }

    @JvmName("ptrgrvimahlvunlb")
    public suspend fun selectedDatabases(
        vararg
        values: Output<MigrateMySqlAzureDbForMySqlOfflineDatabaseInputArgs>,
    ) {
        this.selectedDatabases = Output.all(values.asList())
    }

    /**
     * @param values Databases to migrate
     */
    @JvmName("jigwfdgwvcsinmwr")
    public suspend
    fun selectedDatabases(values: List<Output<MigrateMySqlAzureDbForMySqlOfflineDatabaseInputArgs>>) {
        this.selectedDatabases = Output.all(values)
    }

    /**
     * @param value Connection information for source MySQL
     */
    @JvmName("llbketishuvdjrfv")
    public suspend fun sourceConnectionInfo(`value`: Output<MySqlConnectionInfoArgs>) {
        this.sourceConnectionInfo = value
    }

    /**
     * @param value Parameter to specify when the migration started
     */
    @JvmName("erxrhntjvupldndm")
    public suspend fun startedOn(`value`: Output<String>) {
        this.startedOn = value
    }

    /**
     * @param value Connection information for target Azure Database for MySQL
     */
    @JvmName("vanvcnbpjnaymoqn")
    public suspend fun targetConnectionInfo(`value`: Output<MySqlConnectionInfoArgs>) {
        this.targetConnectionInfo = value
    }

    /**
     * @param value Setting to set the source server read only
     */
    @JvmName("hyejasutonmtfnyr")
    public suspend fun makeSourceServerReadOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.makeSourceServerReadOnly = mapped
    }

    /**
     * @param value Optional parameters for fine tuning the data transfer rate during migration
     */
    @JvmName("cixxwbkjdwboohxn")
    public suspend fun optionalAgentSettings(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optionalAgentSettings = mapped
    }

    /**
     * @param values Optional parameters for fine tuning the data transfer rate during migration
     */
    @JvmName("lgyggqhqvxqvduwh")
    public fun optionalAgentSettings(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.optionalAgentSettings = mapped
    }

    /**
     * @param value Databases to migrate
     */
    @JvmName("giokbeskdqmhfaaf")
    public suspend
    fun selectedDatabases(`value`: List<MigrateMySqlAzureDbForMySqlOfflineDatabaseInputArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("tboicehnwqartsgk")
    public suspend
    fun selectedDatabases(argument: List<suspend MigrateMySqlAzureDbForMySqlOfflineDatabaseInputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MigrateMySqlAzureDbForMySqlOfflineDatabaseInputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("bpekgrtqrmhhuvja")
    public suspend fun selectedDatabases(
        vararg
        argument: suspend MigrateMySqlAzureDbForMySqlOfflineDatabaseInputArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MigrateMySqlAzureDbForMySqlOfflineDatabaseInputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("twfuhadlrfmytwmo")
    public suspend
    fun selectedDatabases(argument: suspend MigrateMySqlAzureDbForMySqlOfflineDatabaseInputArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                MigrateMySqlAzureDbForMySqlOfflineDatabaseInputArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param values Databases to migrate
     */
    @JvmName("gppyxarulpqluctm")
    public suspend fun selectedDatabases(
        vararg
        values: MigrateMySqlAzureDbForMySqlOfflineDatabaseInputArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param value Connection information for source MySQL
     */
    @JvmName("updidtooxeflsjxf")
    public suspend fun sourceConnectionInfo(`value`: MySqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for source MySQL
     */
    @JvmName("ryrtmunggsfrdoff")
    public suspend
    fun sourceConnectionInfo(argument: suspend MySqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = MySqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param value Parameter to specify when the migration started
     */
    @JvmName("qkaipheecxacavrb")
    public suspend fun startedOn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startedOn = mapped
    }

    /**
     * @param value Connection information for target Azure Database for MySQL
     */
    @JvmName("hjblwydclpwspvor")
    public suspend fun targetConnectionInfo(`value`: MySqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for target Azure Database for MySQL
     */
    @JvmName("ncjltwxrhmttgflr")
    public suspend
    fun targetConnectionInfo(argument: suspend MySqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = MySqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetConnectionInfo = mapped
    }

    internal fun build(): MigrateMySqlAzureDbForMySqlOfflineTaskInputArgs =
        MigrateMySqlAzureDbForMySqlOfflineTaskInputArgs(
            makeSourceServerReadOnly = makeSourceServerReadOnly,
            optionalAgentSettings = optionalAgentSettings,
            selectedDatabases = selectedDatabases ?: throw PulumiNullFieldException("selectedDatabases"),
            sourceConnectionInfo = sourceConnectionInfo ?: throw
                PulumiNullFieldException("sourceConnectionInfo"),
            startedOn = startedOn,
            targetConnectionInfo = targetConnectionInfo ?: throw
                PulumiNullFieldException("targetConnectionInfo"),
        )
}
