@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MigrateMySqlAzureDbForMySqlSyncTaskInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Input for the task that migrates MySQL databases to Azure Database for MySQL for online migrations
 * @property selectedDatabases Databases to migrate
 * @property sourceConnectionInfo Connection information for source MySQL
 * @property targetConnectionInfo Connection information for target Azure Database for MySQL
 */
public data class MigrateMySqlAzureDbForMySqlSyncTaskInputArgs(
    public val selectedDatabases: Output<List<MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs>>,
    public val sourceConnectionInfo: Output<MySqlConnectionInfoArgs>,
    public val targetConnectionInfo: Output<MySqlConnectionInfoArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MigrateMySqlAzureDbForMySqlSyncTaskInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.MigrateMySqlAzureDbForMySqlSyncTaskInputArgs =
        com.pulumi.azurenative.datamigration.inputs.MigrateMySqlAzureDbForMySqlSyncTaskInputArgs.builder()
            .selectedDatabases(
                selectedDatabases.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceConnectionInfo(
                sourceConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .targetConnectionInfo(
                targetConnectionInfo.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [MigrateMySqlAzureDbForMySqlSyncTaskInputArgs].
 */
@PulumiTagMarker
public class MigrateMySqlAzureDbForMySqlSyncTaskInputArgsBuilder internal constructor() {
    private var selectedDatabases: Output<List<MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs>>? =
        null

    private var sourceConnectionInfo: Output<MySqlConnectionInfoArgs>? = null

    private var targetConnectionInfo: Output<MySqlConnectionInfoArgs>? = null

    /**
     * @param value Databases to migrate
     */
    @JvmName("apuocecgmghrbqhe")
    public suspend
    fun selectedDatabases(`value`: Output<List<MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs>>) {
        this.selectedDatabases = value
    }

    @JvmName("ahxatypjtjvkojrf")
    public suspend fun selectedDatabases(
        vararg
        values: Output<MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs>,
    ) {
        this.selectedDatabases = Output.all(values.asList())
    }

    /**
     * @param values Databases to migrate
     */
    @JvmName("htnnebklhhlkwrsb")
    public suspend
    fun selectedDatabases(values: List<Output<MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs>>) {
        this.selectedDatabases = Output.all(values)
    }

    /**
     * @param value Connection information for source MySQL
     */
    @JvmName("hqmtijjlvgrckwpd")
    public suspend fun sourceConnectionInfo(`value`: Output<MySqlConnectionInfoArgs>) {
        this.sourceConnectionInfo = value
    }

    /**
     * @param value Connection information for target Azure Database for MySQL
     */
    @JvmName("whnqqinncgpitlar")
    public suspend fun targetConnectionInfo(`value`: Output<MySqlConnectionInfoArgs>) {
        this.targetConnectionInfo = value
    }

    /**
     * @param value Databases to migrate
     */
    @JvmName("yjopeacmbfunorbi")
    public suspend
    fun selectedDatabases(`value`: List<MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("rnfooxdjumtnbtvt")
    public suspend
    fun selectedDatabases(argument: List<suspend MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("ayxjsdtfjmesjbya")
    public suspend fun selectedDatabases(
        vararg
        argument: suspend MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param argument Databases to migrate
     */
    @JvmName("icxxgqfunywxvypu")
    public suspend
    fun selectedDatabases(argument: suspend MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.selectedDatabases = mapped
    }

    /**
     * @param values Databases to migrate
     */
    @JvmName("kvogkdxwqsispveg")
    public suspend fun selectedDatabases(
        vararg
        values: MigrateMySqlAzureDbForMySqlSyncDatabaseInputArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectedDatabases = mapped
    }

    /**
     * @param value Connection information for source MySQL
     */
    @JvmName("wimpywelwmouvleu")
    public suspend fun sourceConnectionInfo(`value`: MySqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for source MySQL
     */
    @JvmName("xxrthtxlpysbkhvr")
    public suspend
    fun sourceConnectionInfo(argument: suspend MySqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = MySqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceConnectionInfo = mapped
    }

    /**
     * @param value Connection information for target Azure Database for MySQL
     */
    @JvmName("sqsvgcpyyosfkeum")
    public suspend fun targetConnectionInfo(`value`: MySqlConnectionInfoArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetConnectionInfo = mapped
    }

    /**
     * @param argument Connection information for target Azure Database for MySQL
     */
    @JvmName("wnnxnlftorkwajnj")
    public suspend
    fun targetConnectionInfo(argument: suspend MySqlConnectionInfoArgsBuilder.() -> Unit) {
        val toBeMapped = MySqlConnectionInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetConnectionInfo = mapped
    }

    internal fun build(): MigrateMySqlAzureDbForMySqlSyncTaskInputArgs =
        MigrateMySqlAzureDbForMySqlSyncTaskInputArgs(
            selectedDatabases = selectedDatabases ?: throw PulumiNullFieldException("selectedDatabases"),
            sourceConnectionInfo = sourceConnectionInfo ?: throw
                PulumiNullFieldException("sourceConnectionInfo"),
            targetConnectionInfo = targetConnectionInfo ?: throw
                PulumiNullFieldException("targetConnectionInfo"),
        )
}
