@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datamigration.kotlin.inputs

import com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlDbDatabaseInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Database specific information for SQL to Azure SQL DB migration task inputs
 * @property makeSourceDbReadOnly Whether to set database read only before migration
 * @property name Name of the database
 * @property tableMap Mapping of source to target tables
 * @property targetDatabaseName Name of target database. Note: Target database will be truncated before starting migration.
 */
public data class MigrateSqlServerSqlDbDatabaseInputArgs(
    public val makeSourceDbReadOnly: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val tableMap: Output<Map<String, String>>? = null,
    public val targetDatabaseName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlDbDatabaseInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlDbDatabaseInputArgs =
        com.pulumi.azurenative.datamigration.inputs.MigrateSqlServerSqlDbDatabaseInputArgs.builder()
            .makeSourceDbReadOnly(makeSourceDbReadOnly?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tableMap(
                tableMap?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .targetDatabaseName(targetDatabaseName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MigrateSqlServerSqlDbDatabaseInputArgs].
 */
@PulumiTagMarker
public class MigrateSqlServerSqlDbDatabaseInputArgsBuilder internal constructor() {
    private var makeSourceDbReadOnly: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var tableMap: Output<Map<String, String>>? = null

    private var targetDatabaseName: Output<String>? = null

    /**
     * @param value Whether to set database read only before migration
     */
    @JvmName("gihpeqnxlvvapyer")
    public suspend fun makeSourceDbReadOnly(`value`: Output<Boolean>) {
        this.makeSourceDbReadOnly = value
    }

    /**
     * @param value Name of the database
     */
    @JvmName("hoalocsunmmesbwh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Mapping of source to target tables
     */
    @JvmName("vjjfpirffniqeaji")
    public suspend fun tableMap(`value`: Output<Map<String, String>>) {
        this.tableMap = value
    }

    /**
     * @param value Name of target database. Note: Target database will be truncated before starting migration.
     */
    @JvmName("hvebenpqegbmkhgy")
    public suspend fun targetDatabaseName(`value`: Output<String>) {
        this.targetDatabaseName = value
    }

    /**
     * @param value Whether to set database read only before migration
     */
    @JvmName("jilqgphcybadugbx")
    public suspend fun makeSourceDbReadOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.makeSourceDbReadOnly = mapped
    }

    /**
     * @param value Name of the database
     */
    @JvmName("dynqkjeinvfntfen")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Mapping of source to target tables
     */
    @JvmName("aoekvsqgdyqyrild")
    public suspend fun tableMap(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableMap = mapped
    }

    /**
     * @param values Mapping of source to target tables
     */
    @JvmName("fyskgfmolqegbisx")
    public fun tableMap(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableMap = mapped
    }

    /**
     * @param value Name of target database. Note: Target database will be truncated before starting migration.
     */
    @JvmName("lftlnkcsdpewgwud")
    public suspend fun targetDatabaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDatabaseName = mapped
    }

    internal fun build(): MigrateSqlServerSqlDbDatabaseInputArgs =
        MigrateSqlServerSqlDbDatabaseInputArgs(
            makeSourceDbReadOnly = makeSourceDbReadOnly,
            name = name,
            tableMap = tableMap,
            targetDatabaseName = targetDatabaseName,
        )
}
